*************************************************************************************************************************************************
******************************INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS****************************************************
***********************************SINTAXIS CUADROS MARTIMO*********************************************************************
*************************************************************************************************************************************************

**TEMA: TABULADOS TRANSPORTE MARTIMO 2016.
**DIRECCIN DE ESTADSTICAS ECONMICAS.
**UNIDAD DE GESTIN DE ESTADSTICAS ESTRUCTURALES.
**FECHA: 31/08/2017.


**************CUADRO M42.

COMPUTE CABOTAJE=(TRAFICO_C='CABOTAJE').
VARIABLE LABELS CABOTAJE 'Filtro para transporte de cabotaje'.
filter by CABOTAJE.
EXECUTE.

COMPUTE T=1.
VARIABLE LABELS T 'NMERO DE NAVES ARRIBADAS'.
VARIABLE LEVEL T (SCALE).
EXECUTE.

DO IF (MES_ENTRADA<=12).
COMPUTE ENTRADAS=1.
END IF.
VARIABLE LABELS ENTRADAS 'NMERO DE NAVES ENTRADAS'.
VARIABLE LEVEL ENTRADAS (SCALE).
EXECUTE.

DO IF (MES_SALIDA<=12).
COMPUTE SALIDAS=1.
END IF.
VARIABLE LABELS SALIDAS 'NMERO DE NAVES SALIDAS'.
VARIABLE LEVEL SALIDAS (SCALE).
EXECUTE.

* Tablas personalizadas.
CTABLES
 /VLABELS VARIABLES=PUERTO ENTRADAS PASAJ_ENT SALIDAS PASAJ_SAL DISPLAY=BOTH
 /TABLE PUERTO BY ENTRADAS [SUM] + PASAJ_ENT [SUM] + SALIDAS [SUM] + PASAJ_SAL [SUM]
 /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
TITLE='TRANSPORTE MARTIMO NACIONAL'
'TRANSPORTE DE CABOTAJE: NMERO DE NAVES ENTRADAS Y SALIDAS POR PUERTO' 
CAPTION='ANUARIO DE TRANSPORTE 2016'.


FILTER OFF.
EXECUTE.


**************CUADRO M43.

COMPUTE INTERNACIONAL=(TRAFICO_C='INTERNACIONAL').
VARIABLE LABELS INTERNACIONAL 'Filtro para transporte internacional'.
FILTER by INTERNACIONAL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C PUERTO DISPLAY=LABEL
  /TABLE BANDERA_C [C] BY PUERTO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=BANDERA_C PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
/TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'NMERO DE NAVES ARRIBADAS POR PUERTO, SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M44.

***ENTRADA***.
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRN MES_ENTRADA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRN [S][SUM] BY MES_ENTRADA [C]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL'
'TONELAJE DE REGISTRO NETO DE LAS NAVES ENTRADAS, POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


***SALIDA***.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRN MES_SALIDA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRN [S][SUM] BY MES_SALIDA
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL'
'TONELAJE DE REGISTRO NETO DE LAS NAVES SALIDAS, POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M45.

***ENTRADA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRB MES_ENTRADA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRB [S][SUM] BY MES_ENTRADA
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'	
'TONELAJE DE REGISTRO BRUTO DE LAS NAVES ENTRADAS, POR MESES' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


***SALIDA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRB MES_SALIDA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRB [SUM] BY MES_SALIDA [C]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL'
'TONELAJE DE REGISTRO BRUTO DE LAS NAVES SALIDAS, POR MESES' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M46.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C MES_ENTRADA DISPLAY=LABEL
  /TABLE BANDERA_C BY MES_ENTRADA [C][COUNT F40.0]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'NMERO DE NAVES ARRIBADAS POR MESES, SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M47.

**ENTRADA DE PASAJEROS***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_ENTRADA PASAJ_ENT DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_ENTRADA > PASAJ_ENT [S][SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'NMERO DE PASAJEROS ENTRADOS POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


***SALIDA DE PASAJEROS***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_SALIDA PASAJ_SAL DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_SALIDA [C] > PASAJ_SAL [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'	
'NMERO DE PASAJEROS SALIDOS POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M48.

***CARGA ENTRADA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_ENTRADA ETC DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_ENTRADA > ETC [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
   /TITLES TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'TOTAL DE CARGA ENTRADA (EN TONELADAS) POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


***CARGA SALIDA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_SALIDA STC DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_SALIDA > STC [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL'
'TOTAL DE CARGA SALIDA (EN TONELADAS) POR MESES, SEGN PUERTO' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M49.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
EXECUTE.


**************CUADRO M50.

COMPUTE ESMERALDAS=(TRAFICO_C='INTERNACIONAL' & PUERTO='APE').
VARIABLE LABELS ESMERALDAS 'Filtro para transporte internacional - Puerto de Esmeraldas'.
FILTER by ESMERALDAS.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL - AUTORIDAD PORTUARIA DE ESMERALDAS (APE)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES ESMERALDAS.
EXECUTE.


**************CUADRO M51.

COMPUTE MANTA=(TRAFICO_C='INTERNACIONAL' & PUERTO='APM').
VARIABLE LABELS MANTA 'Filtro para transporte internacional - Puerto de Manta'.
FILTER by MANTA.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL - AUTORIDAD PORTUARIA DE MANTA (APM)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES MANTA.
EXECUTE.


**************CUADRO M52.

COMPUTE GUAYAQUIL=(TRAFICO_C='INTERNACIONAL' & PUERTO='APG').
VARIABLE LABELS GUAYAQUIL 'Filtro para transporte internacional - Puerto de Guayaquil'.
FILTER by GUAYAQUIL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL - AUTORIDAD PORTUARIA DE GUAYAQUIL (APG)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES GUAYAQUIL.
EXECUTE.


**************CUADRO M53.

COMPUTE BOLIVAR=(TRAFICO_C='INTERNACIONAL' & PUERTO='APPB').
VARIABLE LABELS BOLIVAR 'Filtro para transporte internacional - Puerto Bolvar'.
FILTER by BOLIVAR.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL - AUTORIDAD PORTUARIA DE PUERTO BOLVAR (APPB)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES BOLIVAR.
EXECUTE.


**************CUADRO M54.

COMPUTE BALAO=(TRAFICO_C='INTERNACIONAL' & PUERTO='SUINBA').
VARIABLE LABELS BALAO 'Filtro para transporte internacional - Superintendencia Petrolera de Balao'.
FILTER by BALAO.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL - SUPERINTENDENCIA PETROLERA DE BALAO (SUINBA)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES BALAO.
EXECUTE.


**************CUADRO M55.

COMPUTE LIBERTAD=(TRAFICO_C='INTERNACIONAL' & PUERTO='SUINLI').
VARIABLE LABELS LIBERTAD 'Filtro para transporte internacional - Superintendencia Petrolera de La Libertad'.
FILTER by LIBERTAD.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO INTERNACIONAL - SUPERINTENDENCIA PETROLERA DE LA LIBERTAD (SUINLI)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES LIBERTAD.
EXECUTE.


**************CUADRO M56.

COMPUTE SALITRAL=(TRAFICO_C='INTERNACIONAL' & PUERTO='SUINSA').
VARIABLE LABELS SALITRAL 'Filtro para transporte internacional - Superintendencia Petrolera El Salitral'.
FILTER by SALITRAL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL - SUPERINTENDENCIA PETROLERA EL SALITRAL (SUINSA)'
'NMERO DE NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA (TM), SEGN BANDERAS' 
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.
DELETE VARIABLES SALITRAL.
EXECUTE.


**************CUADRO M57.

COMPUTE TCONT_20= SUM.1(ENT_NCONT_20, SAL_NCONT_20).
COMPUTE TCONT_40= SUM.1(ENT_NCONT_40, SAL_NCONT_40).
COMPUTE TCONT= SUM.1(TCONT_20, TCONT_40).
VARIABLE LABELS TCONT_20 'Total nmero de contenedores de 20'.
VARIABLE LABELS TCONT_40 'Total nmero de contenedores de 40'.
VARIABLE LABELS TCONT 'Total nmero de contenedores'.
VARIABLE LEVEL TCONT_20 TCONT_40 TCONT (SCALA).
FORMATS TCONT ENT_NCONT_20 ENT_NCONT_40 SAL_NCONT_20 SAL_NCONT_40 TCONT_20 TCONT_40 (F10.0).
EXECUTE.

FILTER by INTERNACIONAL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=AGENCIA_NAVIERA_C TCONT ENT_NCONT_20 ENT_NCONT_40 SAL_NCONT_20 SAL_NCONT_40 TCONT_20 TCONT_40 DISPLAY=LABEL
  /TABLE AGENCIA_NAVIERA_C BY TCONT [SUM] + ENT_NCONT_20 [SUM] + ENT_NCONT_40 [SUM] + SAL_NCONT_20 [SUM] + SAL_NCONT_40 [SUM] + TCONT_20 [SUM] + TCONT_40 [SUM]
  /CATEGORIES VARIABLES=AGENCIA_NAVIERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'NMERO DE CONTENEDORES CON CARGA MOVILIZADAS SEGN LAS AGENCIAS NAVIERAS' 
'(CANTIDAD EN UNIDADES)'
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


**************CUADRO M58.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES= STC SAL_TOT_CGEN STCC SAL_TOT_CSOL  SAL_TOT_CLIQ DISPLAY=LABEL
  /TABLE AGENCIA_NAVIERA_C [C] BY STC [S][SUM] + SAL_TOT_CGEN [S][SUM] + STCC [S][SUM] + SAL_TOT_CSOL [S][SUM] + SAL_TOT_CLIQ [S][SUM]
  /CATEGORIES VARIABLES=AGENCIA_NAVIERA_C ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO INTERNACIONAL'
'MOVIMIENTOS DE TIPOS DE CARGA DE EXPORTACIN TOTAL SEGN LAS AGENCIAS NAVIERAS' 
'(TONELADAS MTRICAS)'
CAPTION= 'ANUARIO DE TRANSPORTE 2016'.


FILTER OFF.
DELETE VARIABLES  CABOTAJE T INTERNACIONAL ENTRADAS SALIDAS.
EXECUTE.
